<?php
require 'dbconfig.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

function removerAcentos($string) {
    $acentos = array(
        'À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 
        'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ð', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ'
    );
    $semAcentos = array(
        'A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 
        'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'd', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y'
    );
    return str_replace($acentos, $semAcentos, $string);
}

function getVideoDuration($filePath) {
    $ffmpeg = "/usr/bin/ffmpeg";  // Caminho para o binário do ffmpeg, ajuste conforme necessário
    $cmd = "$ffmpeg -i $filePath 2>&1";
    $output = shell_exec($cmd);

    if (preg_match('/Duration: ((\d+):(\d+):(\d+))/s', $output, $time)) {
        $totalSeconds = ($time[2] * 3600) + ($time[3] * 60) + $time[4];
        return $totalSeconds;
    }
    return 0;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['upload'])) {
        // Obter o nome do cliente selecionado
        $cliente_id = $_POST['cliente_id'];

        // Buscar o nome do cliente no banco de dados
        $stmt = $pdo->prepare("SELECT nomecli FROM cliente WHERE id = ?");
        $stmt->execute([$cliente_id]);
        $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($cliente) {
            $clienteNome = removerAcentos($cliente['nomecli']);
            $clienteNome = preg_replace('/[^A-Za-z0-9_\-]/', '_', $clienteNome); // Remove caracteres especiais

            // Configurações do upload
            $uploadDir = 'uploads/' . $clienteNome . '/';
            
            // Verifica se o diretório do cliente existe, se não, cria o diretório
            if (!is_dir($uploadDir)) {
                if (!mkdir($uploadDir, 0777, true)) {
                    echo "<p class='error'>Erro ao criar diretório para o cliente.</p>";
                    exit;
                }
            }

            // Processa cada arquivo enviado
            foreach ($_FILES['files']['name'] as $key => $filename) {
                $relativeFilePath = $clienteNome . '/' . basename($filename);
                $targetFile = $uploadDir . basename($filename);
                $fileType = pathinfo($targetFile, PATHINFO_EXTENSION);

                // Verifica se o filename já existe no banco de dados
                $stmt = $pdo->prepare("SELECT COUNT(*) FROM assets WHERE filename = ? AND cliente_id = ?");
                $stmt->execute([$relativeFilePath, $cliente_id]);
                $fileExists = $stmt->fetchColumn();

                if ($fileExists) {
                    echo "<p class='error'>Um arquivo com o nome $filename já existe para este cliente. Por favor, renomeie o arquivo e tente novamente.</p>";
                } else {
                    // Verifica se o upload foi feito corretamente
                    if (move_uploaded_file($_FILES['files']['tmp_name'][$key], $targetFile)) {
                        // Define se é um vídeo ou não
                        $is_video = in_array($fileType, ['mp4', 'avi', 'mov', 'wmv']) ? 1 : 0;

                        // Definir a duração do arquivo
                        $duration = 30; // Duração padrão para imagens (30 segundos)
                        if ($is_video) {
                            $duration = getVideoDuration($targetFile);
                        }

                        // Insere as informações no banco de dados
                        $stmt = $pdo->prepare("INSERT INTO assets (filename, is_video, duration, cliente_id) VALUES (?, ?, ?, ?)");
                        $stmt->execute([$relativeFilePath, $is_video, $duration, $cliente_id]);

                        echo "<p class='success'>Arquivo $filename carregado e salvo no banco de dados com sucesso!</p>";
                    } else {
                        echo "<p class='error'>Erro ao fazer upload do arquivo $filename.</p>";
                    }
                }
            }
        } else {
            echo "<p class='error'>Cliente não encontrado.</p>";
        }
    }

    if (isset($_POST['create_schedule'])) {
        // Obter o ID do cliente e as datas da programação
        $cliente_id = $_POST['cliente_id'];
        $data_inicial = $_POST['data_inicial'];
        $data_final = $_POST['data_final'];

        // Verifica se todos os campos necessários estão preenchidos
        if (!empty($cliente_id) && !empty($data_inicial) && !empty($data_final)) {
            // Insere a nova programação no banco de dados
            $stmt = $pdo->prepare("INSERT INTO schedule (cliente_id, data_inicial_programacao, data_final_programacao) VALUES (?, ?, ?)");
            $stmt->execute([$cliente_id, $data_inicial, $data_final]);

            echo "<p class='success'>Programação cadastrada com sucesso!</p>";
        } else {
            echo "<p class='error'>Todos os campos são obrigatórios.</p>";
        }
    }

    if (isset($_POST['associate_asset'])) {
        // Lógica para associar arquivos à programação
        $schedule_id = $_POST['schedule_id'];
        $asset_ids = $_POST['asset_ids'] ?? [];

        if (!empty($schedule_id) && !empty($asset_ids)) {
            foreach ($asset_ids as $asset_id) {
                $stmt = $pdo->prepare("INSERT INTO schedule_assets (schedule_id, asset_id) VALUES (?, ?)");
                $stmt->execute([$schedule_id, $asset_id]) or die(print_r($stmt->errorInfo(), true));
            }
            echo "<p class='success'>Arquivos associados à programação com sucesso!</p>";
        } else {
            echo "<p class='error'>Selecione uma programação e pelo menos um arquivo.</p>";
        }
    }

    if (isset($_POST['generate_json'])) {
        // Lógica para gerar o JSON com base na programação selecionada
        $schedule_id = $_POST['schedule_id'];

        // Buscar o nome do cliente para usar no nome do arquivo JSON
        $stmt = $pdo->prepare("
            SELECT c.nomecli 
            FROM schedule s 
            JOIN cliente c ON s.cliente_id = c.id 
            WHERE s.id = ?
        ");
        $stmt->execute([$schedule_id]);
        $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($cliente) {
            $clienteNome = removerAcentos($cliente['nomecli']);
            $clienteNome = preg_replace('/[^A-Za-z0-9_\-]/', '_', $clienteNome); // Remove caracteres especiais

            // Obtém os arquivos associados à programação selecionada
            $stmt = $pdo->prepare("
                SELECT a.filename, a.is_video, a.duration, a.selected, a.drag_selected, a.fullscreen 
                FROM assets a
                JOIN schedule_assets sa ON a.id = sa.asset_id
                WHERE sa.schedule_id = ?
            ");
            $stmt->execute([$schedule_id]);
            $assets = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // Estrutura básica do JSON
            $json = [
                "version" => 42,
                "layout" => "1",
                "settings" => [
                    "ticker" => [
                        "enable" => false,
                        "behavior" => "scroll",
                        "textSpeed" => 3,
                        "rss" => [
                            "enable" => false,
                            "link" => null,
                            "feedDelay" => 10
                        ]
                    ],
                    "ads" => [
                        "adPlaylist" => false,
                        "adCount" => 1,
                        "adInterval" => 60
                    ],
                    "audio" => [
                        "enable" => false,
                        "random" => false,
                        "volume" => 50
                    ]
                ],
                "assets" => [],
                "templateName" => "custom_layout.html",
                "videoWindow" => null,
                "zoneVideoWindow" => [],
                "groupIds" => null
            ];

            // Adiciona os arquivos ao JSON
            foreach ($assets as $asset) {
                $json_asset = [
                    "filename" => $asset['filename'],
                    "duration" => $asset['duration'],
                    "selected" => $asset['selected'],
                    "option" => ["main" => false],
                    "dragSelected" => $asset['drag_selected'],
                    "fullscreen" => $asset['fullscreen']
                ];

                if ($asset['is_video']) {
                    $json_asset["isVideo"] = true;
                }

                $json['assets'][] = $json_asset;
            }

            // Salva o JSON em um arquivo
            $json_filename = "__{$clienteNome}.json";
            file_put_contents($json_filename, json_encode($json, JSON_PRETTY_PRINT));

            echo "<p class='success'>JSON gerado com sucesso! <a href='$json_filename' download>Baixar JSON</a></p>";
        } else {
            echo "<p class='error'>Cliente não encontrado para a programação selecionada.</p>";
        }
    }
}

// Carregar os dados para uso nos formulários
$stmt = $pdo->query("SELECT id, nomecli FROM cliente");
$clientes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Obter os ativos armazenados no banco de dados
$assets = [];
$stmt = $pdo->query("SELECT id, filename, is_video FROM assets");
$assets = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Obter as programações disponíveis
$stmt = $pdo->query("
    SELECT s.id, s.data_inicial_programacao, s.data_final_programacao, c.nomecli 
    FROM schedule s
    JOIN cliente c ON s.cliente_id = c.id
");
$schedules = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro de Programação</title>
    <!-- Incluindo CSS e JS do Flatpickr -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="mvstyle.css"> <!-- Referência ao arquivo CSS externo -->
</head>
<body>
    <div class="container">
        <h1>Cadastro de Programação de Vídeos e Fotos</h1>

        <!-- Formulário de Cadastro de Programação -->
        <h2>1. Cadastrar Programação</h2>
        <form action="index.php" method="post">
            <div>
                <label for="cliente_id">Selecione o Cliente:</label>
                <select name="cliente_id" id="cliente_id" required>
                    <?php foreach ($clientes as $cliente): ?>
                        <option value="<?= $cliente['id'] ?>"><?= $cliente['nomecli'] ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="date-container">
                <div>
                    <label for="data_inicial">Data Inicial:</label>
                    <input type="text" id="data_inicial" name="data_inicial" required>
                </div>
                <div>
                    <label for="data_final">Data Final:</label>
                    <input type="text" id="data_final" name="data_final" required>
                </div>
            </div>
            <button type="submit" name="create_schedule">Cadastrar Programação</button>
        </form>

        <!-- Formulário de Upload de Arquivos -->
        <h2>2. Carregar Vídeos/Fotos</h2>
        <form action="index.php" method="post" enctype="multipart/form-data">
            <label for="file">Selecione um ou mais vídeos ou fotos:</label>
            <input type="file" name="files[]" id="file" multiple required>
            <input type="hidden" name="cliente_id" value="<?= isset($cliente_id) ? $cliente_id : '' ?>">
            <button type="submit" name="upload">Gravar no Banco de Dados</button>
        </form>

        <!-- Formulário de Associação de Assets à Programação -->
        <h2>3. Associar Vídeos/Fotos à Programação</h2>
        <form action="index.php" method="post">
            <label for="schedule_id">Programação:</label>
            <select class="select-programacao" name="schedule_id" id="schedule_id" required>
                <?php foreach ($schedules as $schedule): ?>
                    <option value="<?= $schedule['id'] ?>">
                        <?= $schedule['nomecli'] ?> - De <?= $schedule['data_inicial_programacao'] ?> até <?= $schedule['data_final_programacao'] ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <div class="asset-container">
                <?php if (!empty($assets)) : ?>
                    <?php foreach ($assets as $asset): ?>
                        <div class="asset-item">
                            <?php if ($asset['is_video']): ?>
                                <video src="uploads/<?= $asset['filename'] ?>" controls></video>
                            <?php else: ?>
                                <img src="uploads/<?= $asset['filename'] ?>" alt="<?= $asset['filename'] ?>">
                            <?php endif; ?>
                            <p class="asset-filename"><?= $asset['filename'] ?></p>
                            <input type="checkbox" name="asset_ids[]" value="<?= $asset['id'] ?>">
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p>Nenhum ativo encontrado.</p>
                <?php endif; ?>
            </div>

            <button type="submit" name="associate_asset">Associar Selecionados</button>
        </form>

        <!-- Botão para gerar JSON -->
        <h2>4. Gerar JSON</h2>
        <form action="index.php" method="post">
            <input type="hidden" name="schedule_id" value="<?= isset($schedule_id) ? $schedule_id : '' ?>">
            <button type="submit" name="generate_json">Gerar JSON</button>
        </form>
    </div>

    <!-- Incluindo JS do Flatpickr -->
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        // Configuração dos calendários
        flatpickr("#data_inicial", {
            inline: true,
            dateFormat: "Y-m-d"
        });
        flatpickr("#data_final", {
            inline: true,
            dateFormat: "Y-m-d"
        });
    </script>
</body>
</html>
