<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configuração de conexão com o banco de dados
$servername = "149.56.34.221";
$username = "inventario";
$password = "Inventario@2024";
$dbname = "ozpet_campo_limmpo";

$conn = new mysqli($servername, $username, $password, $dbname);

// Verifica a conexão
if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}

session_start();

$message = "";

// Buscar funcionários para o menu suspenso
$funcionarios = [];
$funcionariosQuery = "SELECT id, nome FROM funcionarios";
$result = $conn->query($funcionariosQuery);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $funcionarios[] = $row;
    }
}

// Registrar o auditor
if (!isset($_SESSION['auditor_name']) && isset($_POST['auditor_id'])) {
    $auditor_id = $_POST['auditor_id'];

    // Buscar o nome do auditor pelo ID
    $auditorQuery = "SELECT nome FROM funcionarios WHERE id = ?";
    $stmt = $conn->prepare($auditorQuery);
    $stmt->bind_param("i", $auditor_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $auditor = $result->fetch_assoc();
    $stmt->close();

    if ($auditor) {
        $_SESSION['auditor_name'] = $auditor['nome'];

        // Verifica se o auditor já tem um código em andamento
        $checkAuditorQuery = "
            SELECT COUNT(*) as unfinished_count 
            FROM inventory 
            WHERE auditor_name = ? AND finalizado = 0
        ";
        $stmt = $conn->prepare($checkAuditorQuery);
        $stmt->bind_param("s", $_SESSION['auditor_name']);
        $stmt->execute();
        $result = $stmt->get_result();
        $unfinished_count = $result->fetch_assoc()['unfinished_count'] ?? 0;
        $stmt->close();

        if ($unfinished_count > 0) {
            $message = "Erro: Você já possui uma contagem em andamento. Finalize antes de iniciar outra.";
            unset($_SESSION['auditor_name']);
        }
    }
}

$auditor_name = $_SESSION['auditor_name'] ?? null;

// Registrar o código de barras
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['barcode']) && !empty($auditor_name)) {
    $scanned_barcode = $_POST['barcode'];

    // Valida o tamanho do código de barras (mínimo de 13 dígitos)
    if (strlen($scanned_barcode) < 13) {
        $message = "Erro: O código de barras deve ter pelo menos 13 dígitos.";
    } else {
        // Verifica se o auditor já tem outro código em andamento
        $checkCurrentCodeQuery = "
            SELECT barcode 
            FROM inventory 
            WHERE auditor_name = ? AND finalizado = 0
        ";
        $stmt = $conn->prepare($checkCurrentCodeQuery);
        $stmt->bind_param("s", $auditor_name);
        $stmt->execute();
        $result = $stmt->get_result();
        $currentCode = $result->fetch_assoc()['barcode'] ?? null;
        $stmt->close();

        if ($currentCode && $currentCode !== $scanned_barcode) {
            $message = "Erro: Você já está registrando o código '$currentCode'. Finalize antes de iniciar outro.";
        } else {
            // Verifica se outro auditor está utilizando este código
            $checkOtherAuditorQuery = "
                SELECT auditor_name 
                FROM inventory 
                WHERE barcode = ? AND finalizado = 0
            ";
            $stmt = $conn->prepare($checkOtherAuditorQuery);
            $stmt->bind_param("s", $scanned_barcode);
            $stmt->execute();
            $result = $stmt->get_result();
            $otherAuditor = $result->fetch_assoc()['auditor_name'] ?? null;
            $stmt->close();

            if ($otherAuditor && $otherAuditor !== $auditor_name) {
                $message = "Erro: O código '$scanned_barcode' já está sendo utilizado por outro auditor.";
            } else {
                // Atualiza ou insere o registro
                $checkQuery = "
                    SELECT id, quantity 
                    FROM inventory 
                    WHERE barcode = ? AND auditor_name = ? AND finalizado = 0
                ";
                $stmt = $conn->prepare($checkQuery);
                $stmt->bind_param("ss", $scanned_barcode, $auditor_name);
                $stmt->execute();
                $result = $stmt->get_result();
                $row = $result->fetch_assoc();
                $stmt->close();

                if ($row) {
                    // Atualiza a quantidade
                    $updateQuery = "
                        UPDATE inventory 
                        SET quantity = quantity + 1 
                        WHERE id = ?
                    ";
                    $stmt = $conn->prepare($updateQuery);
                    $stmt->bind_param("i", $row['id']);
                    $stmt->execute();
                    $stmt->close();
                    $message = "Quantidade do código '$scanned_barcode' atualizada com sucesso.";
                } else {
                    // Insere o novo registro
                    $insertQuery = "
                        INSERT INTO inventory (barcode, quantity, auditor_name, status, finalizado)
                        VALUES (?, 1, ?, 'iniciado', 0)
                    ";
                    $stmt = $conn->prepare($insertQuery);
                    $stmt->bind_param("ss", $scanned_barcode, $auditor_name);
                    if ($stmt->execute()) {
                        $message = "Código '$scanned_barcode' registrado com sucesso.";
                    } else {
                        $message = "Erro ao registrar o código '$scanned_barcode'.";
                    }
                    $stmt->close();
                }
            }
        }
    }
}

// Obter a contagem de códigos já escaneados
$countQuery = "
    SELECT SUM(quantity) as total 
    FROM inventory 
    WHERE auditor_name = ? AND status = 'iniciado'
";
$stmt = $conn->prepare($countQuery);
$stmt->bind_param("s", $auditor_name);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$total_count = $row ? $row['total'] : 0;
$stmt->close();

// Finalizar contagem
if (isset($_POST['finalize']) && !empty($auditor_name)) {
    $updateQuery = "
        UPDATE inventory 
        SET status = 'finalizado', finalizado = 1 
        WHERE auditor_name = ? AND status = 'iniciado'
    ";
    $stmt = $conn->prepare($updateQuery);
    $stmt->bind_param("s", $auditor_name);
    $stmt->execute();
    $stmt->close();

    $message = "Contagem finalizada. Total: $total_count";
    $_SESSION['auditor_name'] = null; // Reseta a sessão
}

// Reiniciar o processo
if (isset($_POST['reset']) && !empty($auditor_name)) {
    $resetQuery = "DELETE FROM inventory WHERE auditor_name = ? AND status = 'iniciado'";
    $stmt = $conn->prepare($resetQuery);
    $stmt->bind_param("s", $auditor_name);
    $stmt->execute();
    $stmt->close();

    $_SESSION['auditor_name'] = null;
    $message = "O processo foi reiniciado.";
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="styles.css">
    <title>Inventário de Estoque</title>
</head>
<body>
    <h1>Inventário de Estoque</h1>

    <!-- Registrar Auditor -->
    <?php if (empty($_SESSION['auditor_name'])): ?>
        <form method="POST">
            <label for="auditor_id">Selecione o Auditor:</label>
            <select id="auditor_id" name="auditor_id" required>
                <option value="" disabled selected>Selecione...</option>
                <?php foreach ($funcionarios as $funcionario): ?>
                    <option value="<?= $funcionario['id']; ?>"><?= htmlspecialchars($funcionario['nome']); ?></option>
                <?php endforeach; ?>
            </select>
            <input type="submit" value="Iniciar">
        </form>
    <?php else: ?>
        <p>Auditor: <?= htmlspecialchars($_SESSION['auditor_name']); ?></p>

        <!-- Registrar Código de Barras -->
        <form method="POST">
            <label for="barcode">Código de Barras:</label>
            <input type="text" id="barcode" name="barcode" required autofocus>
            <input type="submit" value="Registrar">
        </form>

        <!-- Exibir contagem -->
        <h3>Total de produtos escaneados: <?= $total_count; ?></h3>

        <!-- Mensagem -->
        <?php if (!empty($message)): ?>
            <p><?= htmlspecialchars($message); ?></p>
        <?php endif; ?>

        <!-- Botões para finalizar ou reiniciar -->
        <form method="POST">
            <input type="hidden" name="finalize" value="1">
            <input type="submit" value="Gravar Total">
        </form>

        <form method="POST">
            <input type="hidden" name="reset" value="1">
            <input type="submit" value="Reiniciar Processo">
        </form>
    <?php endif; ?>
</body>
</html>
