<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configuração de conexão com o banco de dados
$servername = "149.56.34.221";
$username = "inventario";
$password = "Inventario@2024";
$dbname = "ozpet_campo_limpo_dev";

$conn = new mysqli($servername, $username, $password, $dbname);

// Verifica a conexão
if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}

session_start();

$error_message = ""; // Variável para mensagens de erro
$barcode_value = ""; // Variável para reter o último código de barras lido
$manual_quantity = 0; // Variável para a quantidade manual

// Verificar se a sessão do auditor existe
if (!isset($_SESSION['auditor'])) {
    session_unset(); // Limpar sessão
    session_destroy(); // Encerrar sessão
    header("Location: define_auditor.php"); // Redirecionar para seleção de auditor
    exit;
}

// Nome do auditor ativo
$auditorName = $_SESSION['auditor'];

// Botão "Finalizar Contagem"
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['finalizar_contagem'])) {
    $barcode_value = $_POST['last_barcode'] ?? ""; // Último código de barras lido
    $manual_quantity = intval($_POST['manual_quantity'] ?? 0);

    if (!empty($barcode_value)) {
        // Atualizar a quantidade e marcar como finalizado
        $update_query = "UPDATE inventory SET quantity = ?, auditor_name = ?, finalizado = 1 WHERE barcode = ?";
        $stmt = $conn->prepare($update_query);
        $stmt->bind_param("iss", $manual_quantity, $auditorName, $barcode_value);
        if ($stmt->execute()) {
            $error_message = "Contagem finalizada com sucesso!";
            $manual_quantity = 0; // Resetar a quantidade manual
        } else {
            $error_message = "Erro ao finalizar a contagem.";
        }
        $stmt->close();
    } else {
        $error_message = "Erro: Nenhum código de barras lido.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="styles.css">
    <title>Inventário de Estoque</title>
    <style>
        .error {
            color: red;
            font-weight: bold;
            margin-top: 10px;
        }
        .success {
            color: green;
            font-weight: bold;
            margin-top: 10px;
        }
        input[type="text"]{
    text-align: center;
}
    </style>
<script>
    // Função para validar o código de barras e incrementar quantidade
    async function validateBarcode(barcode) {
        if (barcode.length === 13) {
            const auditorName = "<?php echo $_SESSION['auditor']; ?>"; // Obter o auditor ativo da sessão
            const response = await fetch('validate_barcode.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ barcode, auditor_name: auditorName }),
            });
            const result = await response.json();

            const messageElement = document.getElementById('message');
            if (result.success) {
                const manualQuantityInput = document.getElementById('manual_quantity');
                manualQuantityInput.value = parseInt(manualQuantityInput.value || 0) + 1;
                document.getElementById('last_barcode').value = barcode;
                document.getElementById('barcode').value = ''; // Limpar o campo
                messageElement.className = "success";
                messageElement.textContent = "Código de barras processado com sucesso.";
            } else {
                messageElement.className = "error";
                messageElement.textContent = result.message; // Mostra a mensagem de erro
                document.getElementById('barcode').value = ''; // Limpar o campo
            }
        }
    }
</script>

</head>
<body>
    <header>
        <h1><?php echo "Inventário de Estoque - Auditor ativo: " . $auditorName; ?></h1>

    </header>
    <main>
        <form method="POST" action="">
            <!-- Área de Mensagem -->
            <p id="message" class="<?php echo strpos($error_message, 'sucesso') !== false ? 'success' : 'error'; ?>">
                <?php echo $error_message; ?>
            </p>

            <label for="barcode">Código de Barras:</label>
            <input type="text" id="barcode" name="barcode" autofocus oninput="validateBarcode(this.value)">

            <label for="manual_quantity">Quantidade Manual:</label>
            <input type="number" id="manual_quantity" name="manual_quantity" value="<?php echo $manual_quantity; ?>" readonly>

            <input type="hidden" id="last_barcode" name="last_barcode" value="<?php echo htmlspecialchars($barcode_value); ?>">
<p></p>
            <center><button type="submit" name="finalizar_contagem">Finalizar Contagem</button></center>
        </form>
        <form method="POST" action="limpa.php">
            <center><button type="submit">Encerrar Sessão</button></center>
        </form>
    </main>
</body>
</html>
